BEGIN;

--
-- Class WenzDocGroup as table wenz_doc_group
--
CREATE TABLE "wenz_doc_group" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "title" text,
    "docRepoId" text,
    "orderIndex" bigint,
    "description" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "doc_group_uuid_idx" ON "wenz_doc_group" USING btree ("uuid");
CREATE INDEX "doc_group_userId_idx" ON "wenz_doc_group" USING btree ("userId");
CREATE INDEX "doc_group_repoId_idx" ON "wenz_doc_group" USING btree ("docRepoId");

--
-- Class WenzDocGroupRecord as table wenz_doc_group_record
--
CREATE TABLE "wenz_doc_group_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docGroupId" uuid NOT NULL,
    "title" text,
    "docRepoId" text,
    "orderIndex" bigint,
    "description" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_group_record_uuid_idx" ON "wenz_doc_group_record" USING btree ("uuid");
CREATE INDEX "doc_group_record_userId_idx" ON "wenz_doc_group_record" USING btree ("userId");
CREATE INDEX "doc_group_record_docGroupId_idx" ON "wenz_doc_group_record" USING btree ("docGroupId");

--
-- Class WenzDocNode as table wenz_doc_node
--
CREATE TABLE "wenz_doc_node" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docRepoId" text,
    "docGroupId" text,
    "orderIndex" bigint,
    "puuid" text,
    "title" text,
    "tags" text,
    "docType" text,
    "fileName" text,
    "filePath" text,
    "docNodeType" text,
    "docNodeContent" text,
    "textContent" text,
    "previewContent" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "images" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "doc_node_uuid_idx" ON "wenz_doc_node" USING btree ("uuid");
CREATE INDEX "doc_node_userId_idx" ON "wenz_doc_node" USING btree ("userId");
CREATE INDEX "doc_node_repoId_idx" ON "wenz_doc_node" USING btree ("docRepoId");

--
-- Class WenzDocNodeContent as table wenz_doc_node_content
--
CREATE TABLE "wenz_doc_node_content" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docNodeId" text,
    "docRepoId" text,
    "docGroupId" text,
    "title" text,
    "tags" text,
    "docType" text,
    "fileName" text,
    "filePath" text,
    "docNodeType" text,
    "docNodeContent" text,
    "textContent" text,
    "previewContent" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "images" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "doc_node_content_uuid_idx" ON "wenz_doc_node_content" USING btree ("uuid");
CREATE INDEX "doc_node_content_userId_idx" ON "wenz_doc_node_content" USING btree ("userId");
CREATE INDEX "doc_node_content_docNodeId_idx" ON "wenz_doc_node_content" USING btree ("docNodeId");

--
-- Class WenzDocNodeContentRecord as table wenz_doc_node_content_record
--
CREATE TABLE "wenz_doc_node_content_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docNodeId" text,
    "docRepoId" text,
    "docGroupId" text,
    "docContentId" text,
    "version" text,
    "title" text,
    "tags" text,
    "docType" text,
    "fileName" text,
    "filePath" text,
    "docNodeType" text,
    "docNodeContent" text,
    "textContent" text,
    "previewContent" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "images" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_node_content_record_uuid_idx" ON "wenz_doc_node_content_record" USING btree ("uuid");
CREATE INDEX "doc_node_content_record_userId_idx" ON "wenz_doc_node_content_record" USING btree ("userId");
CREATE INDEX "doc_node_content_record_nodeId_idx" ON "wenz_doc_node_content_record" USING btree ("docNodeId");

--
-- Class WenzDocNodeRecord as table wenz_doc_node_record
--
CREATE TABLE "wenz_doc_node_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docNodeId" text,
    "docRepoId" text,
    "docGroupId" text,
    "orderIndex" bigint,
    "version" text,
    "puuid" text,
    "title" text,
    "tags" text,
    "docType" text,
    "fileName" text,
    "filePath" text,
    "docNodeType" text,
    "docNodeContent" text,
    "textContent" text,
    "previewContent" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "images" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_node_record_uuid_idx" ON "wenz_doc_node_record" USING btree ("uuid");
CREATE INDEX "doc_node_record_userId_idx" ON "wenz_doc_node_record" USING btree ("userId");
CREATE INDEX "doc_node_record_repoId_idx" ON "wenz_doc_node_record" USING btree ("docRepoId");
CREATE INDEX "doc_node_record_nodeId_idx" ON "wenz_doc_node_record" USING btree ("docNodeId");

--
-- Class WenzDocRepository as table wenz_doc_repository
--
CREATE TABLE "wenz_doc_repository" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "title" text,
    "tags" text,
    "author" text,
    "cover" text,
    "docId" text,
    "docType" text,
    "description" text,
    "category" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "gitUrl" text,
    "gitWebUrl" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "doc_repo_uuid_idx" ON "wenz_doc_repository" USING btree ("uuid");
CREATE INDEX "doc_repo_userId_idx" ON "wenz_doc_repository" USING btree ("userId");
CREATE INDEX "doc_repo_docId_idx" ON "wenz_doc_repository" USING btree ("docId");

--
-- Class WenzDocRepositoryRecord as table wenz_doc_repository_record
--
CREATE TABLE "wenz_doc_repository_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docRepoId" uuid NOT NULL,
    "title" text,
    "tags" text,
    "author" text,
    "cover" text,
    "docId" text,
    "docType" text,
    "description" text,
    "category" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "gitUrl" text,
    "gitWebUrl" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_repo_record_uuid_idx" ON "wenz_doc_repository_record" USING btree ("uuid");
CREATE INDEX "doc_repo_record_userId_idx" ON "wenz_doc_repository_record" USING btree ("userId");
CREATE INDEX "doc_repo_record_docRepoId_idx" ON "wenz_doc_repository_record" USING btree ("docRepoId");

--
-- Class WenzDocRepositoryTag as table wenz_doc_repository_tag
--
CREATE TABLE "wenz_doc_repository_tag" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docRepoId" uuid NOT NULL,
    "tag" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_repo_tag_uuid_idx" ON "wenz_doc_repository_tag" USING btree ("uuid");
CREATE INDEX "doc_repo_tag_userId_idx" ON "wenz_doc_repository_tag" USING btree ("userId");
CREATE INDEX "doc_repo_tag_docRepoId_idx" ON "wenz_doc_repository_tag" USING btree ("docRepoId");

--
-- Class WenzDocTag as table wenz_doc_tag
--
CREATE TABLE "wenz_doc_tag" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docNodeId" uuid NOT NULL,
    "tag" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_tag_uuid_idx" ON "wenz_doc_tag" USING btree ("uuid");
CREATE INDEX "doc_tag_userId_idx" ON "wenz_doc_tag" USING btree ("userId");
CREATE INDEX "doc_tag_docNodeId_idx" ON "wenz_doc_tag" USING btree ("docNodeId");

--
-- Class WenzFile as table wenz_file
--
CREATE TABLE "wenz_file" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint,
    "name" text NOT NULL,
    "path" text NOT NULL,
    "size" bigint NOT NULL,
    "mimeType" text,
    "hash" text,
    "usage" text,
    "associationId" text,
    "storageType" text,
    "url" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deletedTime" timestamp without time zone,
    "deletedBy" text,
    "createdOn" timestamp without time zone NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "createdBy" text,
    "modifiedOn" timestamp without time zone,
    "modifiedBy" text,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid()
);

-- Indexes
CREATE UNIQUE INDEX "file_uuid_unique_idx" ON "wenz_file" USING btree ("uuid");

--
-- Class WenzLink as table wenz_link
--
CREATE TABLE "wenz_link" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "linkSetId" text,
    "targetUuid" text,
    "type" text,
    "title" text,
    "description" text,
    "orderIndex" bigint,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "link_uuid_idx" ON "wenz_link" USING btree ("uuid");
CREATE INDEX "link_linkSetId_idx" ON "wenz_link" USING btree ("linkSetId");
CREATE INDEX "link_targetUuid_idx" ON "wenz_link" USING btree ("targetUuid");
CREATE INDEX "link_userId_idx" ON "wenz_link" USING btree ("userId");
CREATE INDEX "link_type_idx" ON "wenz_link" USING btree ("type");

--
-- Class WenzLinkRecord as table wenz_link_record
--
CREATE TABLE "wenz_link_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "linkId" uuid NOT NULL,
    "linkSetId" text,
    "targetUuid" text,
    "type" text,
    "title" text,
    "description" text,
    "orderIndex" bigint,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "link_record_uuid_idx" ON "wenz_link_record" USING btree ("uuid");
CREATE INDEX "link_record_userId_idx" ON "wenz_link_record" USING btree ("userId");
CREATE INDEX "link_record_linkId_idx" ON "wenz_link_record" USING btree ("linkId");

--
-- Class WenzLinkSet as table wenz_link_set
--
CREATE TABLE "wenz_link_set" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "title" text,
    "description" text,
    "tags" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "linkCount" bigint NOT NULL DEFAULT 0,
    "noteCount" bigint NOT NULL DEFAULT 0,
    "docCount" bigint NOT NULL DEFAULT 0,
    "docNodeCount" bigint NOT NULL DEFAULT 0,
    "taskCount" bigint NOT NULL DEFAULT 0,
    "taskNodeCount" bigint NOT NULL DEFAULT 0,
    "fileCount" bigint NOT NULL DEFAULT 0,
    "urlCount" bigint NOT NULL DEFAULT 0,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "link_set_uuid_idx" ON "wenz_link_set" USING btree ("uuid");
CREATE INDEX "link_set_userId_idx" ON "wenz_link_set" USING btree ("userId");

--
-- Class WenzLinkSetRecord as table wenz_link_set_record
--
CREATE TABLE "wenz_link_set_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "linkSetId" text NOT NULL,
    "title" text,
    "description" text,
    "tags" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "linkCount" bigint NOT NULL DEFAULT 0,
    "noteCount" bigint NOT NULL DEFAULT 0,
    "docCount" bigint NOT NULL DEFAULT 0,
    "docNodeCount" bigint NOT NULL DEFAULT 0,
    "taskCount" bigint NOT NULL DEFAULT 0,
    "taskNodeCount" bigint NOT NULL DEFAULT 0,
    "fileCount" bigint NOT NULL DEFAULT 0,
    "urlCount" bigint NOT NULL DEFAULT 0,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "link_set_record_uuid_idx" ON "wenz_link_set_record" USING btree ("uuid");
CREATE INDEX "link_set_record_userId_idx" ON "wenz_link_set_record" USING btree ("userId");
CREATE INDEX "link_set_record_linkSetId_idx" ON "wenz_link_set_record" USING btree ("linkSetId");

--
-- Class WenzMergeTimeCounter as table wenz_merge_time_counter
--
CREATE TABLE "wenz_merge_time_counter" (
    "id" bigserial PRIMARY KEY,
    "type" text NOT NULL,
    "userId" bigint,
    "currentValue" bigint NOT NULL DEFAULT 0
);

-- Indexes
CREATE UNIQUE INDEX "merge_time_counter_type_userId_idx" ON "wenz_merge_time_counter" USING btree ("type", "userId");

--
-- Class WenzNote as table wenz_note
--
CREATE TABLE "wenz_note" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "title" text,
    "tags" text,
    "noteType" text,
    "noteContent" text,
    "textContent" text,
    "previewContent" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "images" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "note_uuid_idx" ON "wenz_note" USING btree ("uuid");
CREATE INDEX "note_userId_idx" ON "wenz_note" USING btree ("userId");

--
-- Class WenzNoteRecord as table wenz_note_record
--
CREATE TABLE "wenz_note_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "noteId" uuid NOT NULL,
    "title" text,
    "tags" text,
    "noteType" text,
    "noteContent" text,
    "textContent" text,
    "images" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "note_record_uuid_idx" ON "wenz_note_record" USING btree ("uuid");
CREATE INDEX "note_record_userId_idx" ON "wenz_note_record" USING btree ("userId");

--
-- Class WenzNoteShare as table wenz_note_share
--
CREATE TABLE "wenz_note_share" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "noteId" uuid NOT NULL,
    "isPublic" boolean NOT NULL DEFAULT false,
    "password" text,
    "readCount" bigint NOT NULL DEFAULT 0,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "note_share_uuid_idx" ON "wenz_note_share" USING btree ("uuid");
CREATE INDEX "note_share_userId_idx" ON "wenz_note_share" USING btree ("userId");

--
-- Class WenzNoteTag as table wenz_note_tag
--
CREATE TABLE "wenz_note_tag" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "noteId" uuid NOT NULL,
    "tag" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "note_tag_uuid_idx" ON "wenz_note_tag" USING btree ("uuid");
CREATE INDEX "note_tag_userId_idx" ON "wenz_note_tag" USING btree ("userId");
CREATE INDEX "note_tag_noteId_idx" ON "wenz_note_tag" USING btree ("noteId");

--
-- Class WenzTask as table wenz_task
--
CREATE TABLE "wenz_task" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "name" text,
    "description" text,
    "tags" text,
    "difficulty" bigint,
    "urgency" boolean,
    "importance" boolean,
    "estimatedTime" bigint,
    "actualTime" bigint,
    "relationTask" text,
    "relationPlan" text,
    "isCompleted" boolean DEFAULT false,
    "completeDate" timestamp without time zone,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "task_uuid_idx" ON "wenz_task" USING btree ("uuid");
CREATE INDEX "task_userId_idx" ON "wenz_task" USING btree ("userId");

--
-- Class WenzTaskNode as table wenz_task_node
--
CREATE TABLE "wenz_task_node" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "puuid" text,
    "taskId" text,
    "orderIndex" bigint,
    "name" text,
    "description" text,
    "difficulty" bigint,
    "estimatedTime" bigint,
    "actualTime" bigint,
    "isCompleted" boolean,
    "completeDate" timestamp without time zone,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "task_node_uuid_idx" ON "wenz_task_node" USING btree ("uuid");
CREATE INDEX "task_node_task_uuid_idx" ON "wenz_task_node" USING btree ("taskId");
CREATE INDEX "task_node_userId_idx" ON "wenz_task_node" USING btree ("userId");

--
-- Class WenzTaskNodeFile as table wenz_task_node_file
--
CREATE TABLE "wenz_task_node_file" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeId" text,
    "fileId" text,
    "fileName" text,
    "filePath" text,
    "fileUrl" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "task_node_file_uuid_idx" ON "wenz_task_node_file" USING btree ("uuid");
CREATE INDEX "task_node_file_task_node_uuid_idx" ON "wenz_task_node_file" USING btree ("taskNodeId");
CREATE INDEX "task_node_file_userId_idx" ON "wenz_task_node_file" USING btree ("userId");

--
-- Class WenzTaskNodeFileRecord as table wenz_task_node_file_record
--
CREATE TABLE "wenz_task_node_file_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeFileId" uuid NOT NULL,
    "taskNodeId" text,
    "fileId" text,
    "fileName" text,
    "filePath" text,
    "fileUrl" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_file_record_uuid_idx" ON "wenz_task_node_file_record" USING btree ("uuid");
CREATE INDEX "task_node_file_record_userId_idx" ON "wenz_task_node_file_record" USING btree ("userId");
CREATE INDEX "task_node_file_record_taskNodeFileId_idx" ON "wenz_task_node_file_record" USING btree ("taskNodeFileId");

--
-- Class WenzTaskNodeIssue as table wenz_task_node_issue
--
CREATE TABLE "wenz_task_node_issue" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeId" text,
    "title" text,
    "answer" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "task_node_issue_uuid_idx" ON "wenz_task_node_issue" USING btree ("uuid");
CREATE INDEX "task_node_issue_task_node_uuid_idx" ON "wenz_task_node_issue" USING btree ("taskNodeId");
CREATE INDEX "task_node_issue_userId_idx" ON "wenz_task_node_issue" USING btree ("userId");

--
-- Class WenzTaskNodeIssueRecord as table wenz_task_node_issue_record
--
CREATE TABLE "wenz_task_node_issue_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeIssueId" uuid NOT NULL,
    "taskNodeId" text,
    "title" text,
    "answer" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_issue_record_uuid_idx" ON "wenz_task_node_issue_record" USING btree ("uuid");
CREATE INDEX "task_node_issue_record_userId_idx" ON "wenz_task_node_issue_record" USING btree ("userId");
CREATE INDEX "task_node_issue_record_taskNodeIssueId_idx" ON "wenz_task_node_issue_record" USING btree ("taskNodeIssueId");

--
-- Class WenzTaskNodeLink as table wenz_task_node_link
--
CREATE TABLE "wenz_task_node_link" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeId" text,
    "title" text,
    "type" text,
    "link" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "task_node_link_uuid_idx" ON "wenz_task_node_link" USING btree ("uuid");
CREATE INDEX "task_node_link_task_node_uuid_idx" ON "wenz_task_node_link" USING btree ("taskNodeId");
CREATE INDEX "task_node_link_userId_idx" ON "wenz_task_node_link" USING btree ("userId");

--
-- Class WenzTaskNodeLinkRecord as table wenz_task_node_link_record
--
CREATE TABLE "wenz_task_node_link_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeLinkId" uuid NOT NULL,
    "taskNodeId" text,
    "title" text,
    "type" text,
    "link" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_link_record_uuid_idx" ON "wenz_task_node_link_record" USING btree ("uuid");
CREATE INDEX "task_node_link_record_userId_idx" ON "wenz_task_node_link_record" USING btree ("userId");
CREATE INDEX "task_node_link_record_taskNodeLinkId_idx" ON "wenz_task_node_link_record" USING btree ("taskNodeLinkId");

--
-- Class WenzTaskNodeMergeRecord as table wenz_task_node_merge_record
--
CREATE TABLE "wenz_task_node_merge_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeId" uuid NOT NULL,
    "puuid" text,
    "taskId" text,
    "orderIndex" bigint,
    "name" text,
    "description" text,
    "difficulty" bigint,
    "estimatedTime" bigint,
    "actualTime" bigint,
    "isCompleted" boolean,
    "completeDate" timestamp without time zone,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_merge_record_uuid_idx" ON "wenz_task_node_merge_record" USING btree ("uuid");
CREATE INDEX "task_node_merge_record_userId_idx" ON "wenz_task_node_merge_record" USING btree ("userId");
CREATE INDEX "task_node_merge_record_taskNodeId_idx" ON "wenz_task_node_merge_record" USING btree ("taskNodeId");

--
-- Class WenzTaskNodeNote as table wenz_task_node_note
--
CREATE TABLE "wenz_task_node_note" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeId" text,
    "recordId" text,
    "textContent" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "task_node_note_uuid_idx" ON "wenz_task_node_note" USING btree ("uuid");
CREATE INDEX "task_node_note_task_node_uuid_idx" ON "wenz_task_node_note" USING btree ("taskNodeId");
CREATE INDEX "task_node_note_userId_idx" ON "wenz_task_node_note" USING btree ("userId");

--
-- Class WenzTaskNodeNoteRecord as table wenz_task_node_note_record
--
CREATE TABLE "wenz_task_node_note_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "type" text,
    "fileId" text,
    "taskNodeId" text,
    "content" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_note_record_uuid_idx" ON "wenz_task_node_note_record" USING btree ("uuid");
CREATE INDEX "task_node_note_record_task_node_idx" ON "wenz_task_node_note_record" USING btree ("taskNodeId");

--
-- Class WenzTaskNodeRecord as table wenz_task_node_record
--
CREATE TABLE "wenz_task_node_record" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint,
    "taskId" text,
    "taskNodeId" text,
    "eventType" text,
    "eventTime" timestamp without time zone,
    "eventData" text,
    "eventSource" text,
    "actualTime" bigint,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "task_node_record_uuid_idx" ON "wenz_task_node_record" USING btree ("uuid");
CREATE INDEX "task_node_record_idx" ON "wenz_task_node_record" USING btree ("userId", "taskId");

--
-- Class WenzTaskNodeRecordRecord as table wenz_task_node_record_record
--
CREATE TABLE "wenz_task_node_record_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeRecordId" uuid NOT NULL,
    "taskId" text,
    "taskNodeId" text,
    "eventType" text,
    "eventTime" timestamp without time zone,
    "eventData" text,
    "eventSource" text,
    "actualTime" bigint,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_record_record_uuid_idx" ON "wenz_task_node_record_record" USING btree ("uuid");
CREATE INDEX "task_node_record_record_userId_idx" ON "wenz_task_node_record_record" USING btree ("userId");
CREATE INDEX "task_node_record_record_taskNodeRecordId_idx" ON "wenz_task_node_record_record" USING btree ("taskNodeRecordId");

--
-- Class WenzTaskRecord as table wenz_task_record
--
CREATE TABLE "wenz_task_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskId" uuid NOT NULL,
    "name" text,
    "description" text,
    "tags" text,
    "difficulty" bigint,
    "urgency" boolean,
    "importance" boolean,
    "estimatedTime" bigint,
    "actualTime" bigint,
    "relationTask" text,
    "relationPlan" text,
    "isCompleted" boolean DEFAULT false,
    "completeDate" timestamp without time zone,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_record_uuid_idx" ON "wenz_task_record" USING btree ("uuid");
CREATE INDEX "task_record_userId_idx" ON "wenz_task_record" USING btree ("userId");
CREATE INDEX "task_record_taskId_idx" ON "wenz_task_record" USING btree ("taskId");

--
-- Class WenzTaskTag as table wenz_task_tag
--
CREATE TABLE "wenz_task_tag" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskId" uuid NOT NULL,
    "tag" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_tag_uuid_idx" ON "wenz_task_tag" USING btree ("uuid");
CREATE INDEX "task_tag_userId_idx" ON "wenz_task_tag" USING btree ("userId");
CREATE INDEX "task_tag_taskId_idx" ON "wenz_task_tag" USING btree ("taskId");

--
-- Class CloudStorageEntry as table serverpod_cloud_storage
--
CREATE TABLE "serverpod_cloud_storage" (
    "id" bigserial PRIMARY KEY,
    "storageId" text NOT NULL,
    "path" text NOT NULL,
    "addedTime" timestamp without time zone NOT NULL,
    "expiration" timestamp without time zone,
    "byteData" bytea NOT NULL,
    "verified" boolean NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_cloud_storage_path_idx" ON "serverpod_cloud_storage" USING btree ("storageId", "path");
CREATE INDEX "serverpod_cloud_storage_expiration" ON "serverpod_cloud_storage" USING btree ("expiration");

--
-- Class CloudStorageDirectUploadEntry as table serverpod_cloud_storage_direct_upload
--
CREATE TABLE "serverpod_cloud_storage_direct_upload" (
    "id" bigserial PRIMARY KEY,
    "storageId" text NOT NULL,
    "path" text NOT NULL,
    "expiration" timestamp without time zone NOT NULL,
    "authKey" text NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_cloud_storage_direct_upload_storage_path" ON "serverpod_cloud_storage_direct_upload" USING btree ("storageId", "path");

--
-- Class FutureCallEntry as table serverpod_future_call
--
CREATE TABLE "serverpod_future_call" (
    "id" bigserial PRIMARY KEY,
    "name" text NOT NULL,
    "time" timestamp without time zone NOT NULL,
    "serializedObject" text,
    "serverId" text NOT NULL,
    "identifier" text
);

-- Indexes
CREATE INDEX "serverpod_future_call_time_idx" ON "serverpod_future_call" USING btree ("time");
CREATE INDEX "serverpod_future_call_serverId_idx" ON "serverpod_future_call" USING btree ("serverId");
CREATE INDEX "serverpod_future_call_identifier_idx" ON "serverpod_future_call" USING btree ("identifier");

--
-- Class ServerHealthConnectionInfo as table serverpod_health_connection_info
--
CREATE TABLE "serverpod_health_connection_info" (
    "id" bigserial PRIMARY KEY,
    "serverId" text NOT NULL,
    "timestamp" timestamp without time zone NOT NULL,
    "active" bigint NOT NULL,
    "closing" bigint NOT NULL,
    "idle" bigint NOT NULL,
    "granularity" bigint NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_health_connection_info_timestamp_idx" ON "serverpod_health_connection_info" USING btree ("timestamp", "serverId", "granularity");

--
-- Class ServerHealthMetric as table serverpod_health_metric
--
CREATE TABLE "serverpod_health_metric" (
    "id" bigserial PRIMARY KEY,
    "name" text NOT NULL,
    "serverId" text NOT NULL,
    "timestamp" timestamp without time zone NOT NULL,
    "isHealthy" boolean NOT NULL,
    "value" double precision NOT NULL,
    "granularity" bigint NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_health_metric_timestamp_idx" ON "serverpod_health_metric" USING btree ("timestamp", "serverId", "name", "granularity");

--
-- Class LogEntry as table serverpod_log
--
CREATE TABLE "serverpod_log" (
    "id" bigserial PRIMARY KEY,
    "sessionLogId" bigint NOT NULL,
    "messageId" bigint,
    "reference" text,
    "serverId" text NOT NULL,
    "time" timestamp without time zone NOT NULL,
    "logLevel" bigint NOT NULL,
    "message" text NOT NULL,
    "error" text,
    "stackTrace" text,
    "order" bigint NOT NULL
);

-- Indexes
CREATE INDEX "serverpod_log_sessionLogId_idx" ON "serverpod_log" USING btree ("sessionLogId");

--
-- Class MessageLogEntry as table serverpod_message_log
--
CREATE TABLE "serverpod_message_log" (
    "id" bigserial PRIMARY KEY,
    "sessionLogId" bigint NOT NULL,
    "serverId" text NOT NULL,
    "messageId" bigint NOT NULL,
    "endpoint" text NOT NULL,
    "messageName" text NOT NULL,
    "duration" double precision NOT NULL,
    "error" text,
    "stackTrace" text,
    "slow" boolean NOT NULL,
    "order" bigint NOT NULL
);

--
-- Class MethodInfo as table serverpod_method
--
CREATE TABLE "serverpod_method" (
    "id" bigserial PRIMARY KEY,
    "endpoint" text NOT NULL,
    "method" text NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_method_endpoint_method_idx" ON "serverpod_method" USING btree ("endpoint", "method");

--
-- Class DatabaseMigrationVersion as table serverpod_migrations
--
CREATE TABLE "serverpod_migrations" (
    "id" bigserial PRIMARY KEY,
    "module" text NOT NULL,
    "version" text NOT NULL,
    "timestamp" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_migrations_ids" ON "serverpod_migrations" USING btree ("module");

--
-- Class QueryLogEntry as table serverpod_query_log
--
CREATE TABLE "serverpod_query_log" (
    "id" bigserial PRIMARY KEY,
    "serverId" text NOT NULL,
    "sessionLogId" bigint NOT NULL,
    "messageId" bigint,
    "query" text NOT NULL,
    "duration" double precision NOT NULL,
    "numRows" bigint,
    "error" text,
    "stackTrace" text,
    "slow" boolean NOT NULL,
    "order" bigint NOT NULL
);

-- Indexes
CREATE INDEX "serverpod_query_log_sessionLogId_idx" ON "serverpod_query_log" USING btree ("sessionLogId");

--
-- Class ReadWriteTestEntry as table serverpod_readwrite_test
--
CREATE TABLE "serverpod_readwrite_test" (
    "id" bigserial PRIMARY KEY,
    "number" bigint NOT NULL
);

--
-- Class RuntimeSettings as table serverpod_runtime_settings
--
CREATE TABLE "serverpod_runtime_settings" (
    "id" bigserial PRIMARY KEY,
    "logSettings" json NOT NULL,
    "logSettingsOverrides" json NOT NULL,
    "logServiceCalls" boolean NOT NULL,
    "logMalformedCalls" boolean NOT NULL
);

--
-- Class SessionLogEntry as table serverpod_session_log
--
CREATE TABLE "serverpod_session_log" (
    "id" bigserial PRIMARY KEY,
    "serverId" text NOT NULL,
    "time" timestamp without time zone NOT NULL,
    "module" text,
    "endpoint" text,
    "method" text,
    "duration" double precision,
    "numQueries" bigint,
    "slow" boolean,
    "error" text,
    "stackTrace" text,
    "authenticatedUserId" bigint,
    "isOpen" boolean,
    "touched" timestamp without time zone NOT NULL
);

-- Indexes
CREATE INDEX "serverpod_session_log_serverid_idx" ON "serverpod_session_log" USING btree ("serverId");
CREATE INDEX "serverpod_session_log_touched_idx" ON "serverpod_session_log" USING btree ("touched");
CREATE INDEX "serverpod_session_log_isopen_idx" ON "serverpod_session_log" USING btree ("isOpen");

--
-- Class AuthKey as table serverpod_auth_key
--
CREATE TABLE "serverpod_auth_key" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint NOT NULL,
    "hash" text NOT NULL,
    "scopeNames" json NOT NULL,
    "method" text NOT NULL
);

-- Indexes
CREATE INDEX "serverpod_auth_key_userId_idx" ON "serverpod_auth_key" USING btree ("userId");

--
-- Class EmailAuth as table serverpod_email_auth
--
CREATE TABLE "serverpod_email_auth" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint NOT NULL,
    "email" text NOT NULL,
    "hash" text NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_email_auth_email" ON "serverpod_email_auth" USING btree ("email");

--
-- Class EmailCreateAccountRequest as table serverpod_email_create_request
--
CREATE TABLE "serverpod_email_create_request" (
    "id" bigserial PRIMARY KEY,
    "userName" text NOT NULL,
    "email" text NOT NULL,
    "hash" text NOT NULL,
    "verificationCode" text NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_email_auth_create_account_request_idx" ON "serverpod_email_create_request" USING btree ("email");

--
-- Class EmailFailedSignIn as table serverpod_email_failed_sign_in
--
CREATE TABLE "serverpod_email_failed_sign_in" (
    "id" bigserial PRIMARY KEY,
    "email" text NOT NULL,
    "time" timestamp without time zone NOT NULL,
    "ipAddress" text NOT NULL
);

-- Indexes
CREATE INDEX "serverpod_email_failed_sign_in_email_idx" ON "serverpod_email_failed_sign_in" USING btree ("email");
CREATE INDEX "serverpod_email_failed_sign_in_time_idx" ON "serverpod_email_failed_sign_in" USING btree ("time");

--
-- Class EmailReset as table serverpod_email_reset
--
CREATE TABLE "serverpod_email_reset" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint NOT NULL,
    "verificationCode" text NOT NULL,
    "expiration" timestamp without time zone NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_email_reset_verification_idx" ON "serverpod_email_reset" USING btree ("verificationCode");

--
-- Class GoogleRefreshToken as table serverpod_google_refresh_token
--
CREATE TABLE "serverpod_google_refresh_token" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint NOT NULL,
    "refreshToken" text NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_google_refresh_token_userId_idx" ON "serverpod_google_refresh_token" USING btree ("userId");

--
-- Class UserImage as table serverpod_user_image
--
CREATE TABLE "serverpod_user_image" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint NOT NULL,
    "version" bigint NOT NULL,
    "url" text NOT NULL
);

-- Indexes
CREATE INDEX "serverpod_user_image_user_id" ON "serverpod_user_image" USING btree ("userId", "version");

--
-- Class UserInfo as table serverpod_user_info
--
CREATE TABLE "serverpod_user_info" (
    "id" bigserial PRIMARY KEY,
    "userIdentifier" text NOT NULL,
    "userName" text,
    "fullName" text,
    "email" text,
    "created" timestamp without time zone NOT NULL,
    "imageUrl" text,
    "scopeNames" json NOT NULL,
    "blocked" boolean NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "serverpod_user_info_user_identifier" ON "serverpod_user_info" USING btree ("userIdentifier");
CREATE INDEX "serverpod_user_info_email" ON "serverpod_user_info" USING btree ("email");

--
-- Foreign relations for "serverpod_log" table
--
ALTER TABLE ONLY "serverpod_log"
    ADD CONSTRAINT "serverpod_log_fk_0"
    FOREIGN KEY("sessionLogId")
    REFERENCES "serverpod_session_log"("id")
    ON DELETE CASCADE
    ON UPDATE NO ACTION;

--
-- Foreign relations for "serverpod_message_log" table
--
ALTER TABLE ONLY "serverpod_message_log"
    ADD CONSTRAINT "serverpod_message_log_fk_0"
    FOREIGN KEY("sessionLogId")
    REFERENCES "serverpod_session_log"("id")
    ON DELETE CASCADE
    ON UPDATE NO ACTION;

--
-- Foreign relations for "serverpod_query_log" table
--
ALTER TABLE ONLY "serverpod_query_log"
    ADD CONSTRAINT "serverpod_query_log_fk_0"
    FOREIGN KEY("sessionLogId")
    REFERENCES "serverpod_session_log"("id")
    ON DELETE CASCADE
    ON UPDATE NO ACTION;


--
-- MIGRATION VERSION FOR wenzflow
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('wenzflow', '20251203193644044', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20251203193644044', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod', '20240516151843329', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240516151843329', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod_auth
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod_auth', '20240520102713718', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240520102713718', "timestamp" = now();


COMMIT;
