BEGIN;

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_doc_repository_tag" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docRepoId" uuid NOT NULL,
    "tag" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_repo_tag_uuid_idx" ON "wenz_doc_repository_tag" USING btree ("uuid");
CREATE INDEX "doc_repo_tag_userId_idx" ON "wenz_doc_repository_tag" USING btree ("userId");
CREATE INDEX "doc_repo_tag_docRepoId_idx" ON "wenz_doc_repository_tag" USING btree ("docRepoId");


--
-- MIGRATION VERSION FOR wenzflow
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('wenzflow', '20251112230933742', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20251112230933742', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod', '20240516151843329', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240516151843329', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod_auth
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod_auth', '20240520102713718', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240520102713718', "timestamp" = now();


COMMIT;
