BEGIN;

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_doc_node" ADD COLUMN "pidTime" timestamp without time zone;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_file_usage" (
    "id" bigserial PRIMARY KEY,
    "userId" bigint NOT NULL,
    "uuid" text NOT NULL,
    "size" bigint NOT NULL
);

-- Indexes
CREATE UNIQUE INDEX "file_usage_uuid_unique_idx" ON "wenz_file_usage" USING btree ("uuid");
CREATE INDEX "file_usage_userId_idx" ON "wenz_file_usage" USING btree ("userId");

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task_node" ADD COLUMN "pidTime" timestamp without time zone;

--
-- MIGRATION VERSION FOR wenzflow
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('wenzflow', '20260128185817204', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20260128185817204', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod', '20240516151843329', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240516151843329', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod_auth
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod_auth', '20240520102713718', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240520102713718', "timestamp" = now();


COMMIT;
