BEGIN;

--
-- ACTION DROP TABLE
--
DROP TABLE "wenz_doc_node_record_record" CASCADE;

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_doc_group" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_doc_group_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docGroupId" uuid NOT NULL,
    "title" text,
    "docRepoId" text,
    "orderIndex" bigint,
    "description" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_group_record_uuid_idx" ON "wenz_doc_group_record" USING btree ("uuid");
CREATE INDEX "doc_group_record_userId_idx" ON "wenz_doc_group_record" USING btree ("userId");
CREATE INDEX "doc_group_record_docGroupId_idx" ON "wenz_doc_group_record" USING btree ("docGroupId");

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_doc_node" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_doc_node_content" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_doc_node_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docNodeId" text,
    "docRepoId" text,
    "docGroupId" text,
    "orderIndex" bigint,
    "version" text,
    "puuid" text,
    "title" text,
    "tags" text,
    "docType" text,
    "fileName" text,
    "filePath" text,
    "docNodeType" text,
    "docNodeContent" text,
    "textContent" text,
    "previewContent" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "images" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_node_record_uuid_idx" ON "wenz_doc_node_record" USING btree ("uuid");
CREATE INDEX "doc_node_record_userId_idx" ON "wenz_doc_node_record" USING btree ("userId");
CREATE INDEX "doc_node_record_repoId_idx" ON "wenz_doc_node_record" USING btree ("docRepoId");
CREATE INDEX "doc_node_record_nodeId_idx" ON "wenz_doc_node_record" USING btree ("docNodeId");

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_doc_repository" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_doc_repository_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "docRepoId" uuid NOT NULL,
    "title" text,
    "tags" text,
    "author" text,
    "cover" text,
    "docId" text,
    "docType" text,
    "description" text,
    "category" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "gitUrl" text,
    "gitWebUrl" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "doc_repo_record_uuid_idx" ON "wenz_doc_repository_record" USING btree ("uuid");
CREATE INDEX "doc_repo_record_userId_idx" ON "wenz_doc_repository_record" USING btree ("userId");
CREATE INDEX "doc_repo_record_docRepoId_idx" ON "wenz_doc_repository_record" USING btree ("docRepoId");

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_link" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "linkSetId" text,
    "targetUuid" text,
    "type" text,
    "title" text,
    "description" text,
    "orderIndex" bigint,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "link_uuid_idx" ON "wenz_link" USING btree ("uuid");
CREATE INDEX "link_linkSetId_idx" ON "wenz_link" USING btree ("linkSetId");
CREATE INDEX "link_targetUuid_idx" ON "wenz_link" USING btree ("targetUuid");
CREATE INDEX "link_userId_idx" ON "wenz_link" USING btree ("userId");
CREATE INDEX "link_type_idx" ON "wenz_link" USING btree ("type");

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_link_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "linkId" uuid NOT NULL,
    "linkSetId" text,
    "targetUuid" text,
    "type" text,
    "title" text,
    "description" text,
    "orderIndex" bigint,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "link_record_uuid_idx" ON "wenz_link_record" USING btree ("uuid");
CREATE INDEX "link_record_userId_idx" ON "wenz_link_record" USING btree ("userId");
CREATE INDEX "link_record_linkId_idx" ON "wenz_link_record" USING btree ("linkId");

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_link_set" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "title" text,
    "description" text,
    "tags" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "linkCount" bigint NOT NULL DEFAULT 0,
    "noteCount" bigint NOT NULL DEFAULT 0,
    "docCount" bigint NOT NULL DEFAULT 0,
    "docNodeCount" bigint NOT NULL DEFAULT 0,
    "taskCount" bigint NOT NULL DEFAULT 0,
    "taskNodeCount" bigint NOT NULL DEFAULT 0,
    "fileCount" bigint NOT NULL DEFAULT 0,
    "urlCount" bigint NOT NULL DEFAULT 0,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone,
    "serverMergeTime" bigint
);

-- Indexes
CREATE UNIQUE INDEX "link_set_uuid_idx" ON "wenz_link_set" USING btree ("uuid");
CREATE INDEX "link_set_userId_idx" ON "wenz_link_set" USING btree ("userId");

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_link_set_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "linkSetId" text NOT NULL,
    "title" text,
    "description" text,
    "tags" text,
    "top" boolean NOT NULL DEFAULT false,
    "favorite" boolean NOT NULL DEFAULT false,
    "linkCount" bigint NOT NULL DEFAULT 0,
    "noteCount" bigint NOT NULL DEFAULT 0,
    "docCount" bigint NOT NULL DEFAULT 0,
    "docNodeCount" bigint NOT NULL DEFAULT 0,
    "taskCount" bigint NOT NULL DEFAULT 0,
    "taskNodeCount" bigint NOT NULL DEFAULT 0,
    "fileCount" bigint NOT NULL DEFAULT 0,
    "urlCount" bigint NOT NULL DEFAULT 0,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "link_set_record_uuid_idx" ON "wenz_link_set_record" USING btree ("uuid");
CREATE INDEX "link_set_record_userId_idx" ON "wenz_link_set_record" USING btree ("userId");
CREATE INDEX "link_set_record_linkSetId_idx" ON "wenz_link_set_record" USING btree ("linkSetId");

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_merge_time_counter" (
    "id" bigserial PRIMARY KEY,
    "type" text NOT NULL,
    "userId" bigint,
    "currentValue" bigint NOT NULL DEFAULT 0
);

-- Indexes
CREATE UNIQUE INDEX "merge_time_counter_type_userId_idx" ON "wenz_merge_time_counter" USING btree ("type", "userId");

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_note" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_note_share" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task_node" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task_node_file" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_task_node_file_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeFileId" uuid NOT NULL,
    "taskNodeId" text,
    "fileId" text,
    "fileName" text,
    "filePath" text,
    "fileUrl" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_file_record_uuid_idx" ON "wenz_task_node_file_record" USING btree ("uuid");
CREATE INDEX "task_node_file_record_userId_idx" ON "wenz_task_node_file_record" USING btree ("userId");
CREATE INDEX "task_node_file_record_taskNodeFileId_idx" ON "wenz_task_node_file_record" USING btree ("taskNodeFileId");

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task_node_issue" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_task_node_issue_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeIssueId" uuid NOT NULL,
    "taskNodeId" text,
    "title" text,
    "answer" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_issue_record_uuid_idx" ON "wenz_task_node_issue_record" USING btree ("uuid");
CREATE INDEX "task_node_issue_record_userId_idx" ON "wenz_task_node_issue_record" USING btree ("userId");
CREATE INDEX "task_node_issue_record_taskNodeIssueId_idx" ON "wenz_task_node_issue_record" USING btree ("taskNodeIssueId");

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task_node_link" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_task_node_link_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeLinkId" uuid NOT NULL,
    "taskNodeId" text,
    "title" text,
    "type" text,
    "link" text,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_link_record_uuid_idx" ON "wenz_task_node_link_record" USING btree ("uuid");
CREATE INDEX "task_node_link_record_userId_idx" ON "wenz_task_node_link_record" USING btree ("userId");
CREATE INDEX "task_node_link_record_taskNodeLinkId_idx" ON "wenz_task_node_link_record" USING btree ("taskNodeLinkId");

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_task_node_merge_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeId" uuid NOT NULL,
    "puuid" text,
    "taskId" text,
    "orderIndex" bigint,
    "name" text,
    "description" text,
    "difficulty" bigint,
    "estimatedTime" bigint,
    "actualTime" bigint,
    "isCompleted" boolean,
    "completeDate" timestamp without time zone,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_merge_record_uuid_idx" ON "wenz_task_node_merge_record" USING btree ("uuid");
CREATE INDEX "task_node_merge_record_userId_idx" ON "wenz_task_node_merge_record" USING btree ("userId");
CREATE INDEX "task_node_merge_record_taskNodeId_idx" ON "wenz_task_node_merge_record" USING btree ("taskNodeId");

--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task_node_note" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION ALTER TABLE
--
ALTER TABLE "wenz_task_node_record" ADD COLUMN "serverMergeTime" bigint;
--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_task_node_record_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskNodeRecordId" uuid NOT NULL,
    "taskId" text,
    "taskNodeId" text,
    "eventType" text,
    "eventTime" timestamp without time zone,
    "eventData" text,
    "eventSource" text,
    "actualTime" bigint,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_node_record_record_uuid_idx" ON "wenz_task_node_record_record" USING btree ("uuid");
CREATE INDEX "task_node_record_record_userId_idx" ON "wenz_task_node_record_record" USING btree ("userId");
CREATE INDEX "task_node_record_record_taskNodeRecordId_idx" ON "wenz_task_node_record_record" USING btree ("taskNodeRecordId");

--
-- ACTION CREATE TABLE
--
CREATE TABLE "wenz_task_record" (
    "id" bigserial PRIMARY KEY,
    "uuid" uuid NOT NULL DEFAULT gen_random_uuid(),
    "userId" bigint,
    "taskId" uuid NOT NULL,
    "name" text,
    "description" text,
    "tags" text,
    "difficulty" bigint,
    "urgency" boolean,
    "importance" boolean,
    "estimatedTime" bigint,
    "actualTime" bigint,
    "relationTask" text,
    "relationPlan" text,
    "isCompleted" boolean DEFAULT false,
    "completeDate" timestamp without time zone,
    "deleted" boolean NOT NULL DEFAULT false,
    "deleteBy" text,
    "deleteTime" timestamp without time zone,
    "createBy" text,
    "createTime" timestamp without time zone,
    "updateBy" text,
    "updateTime" timestamp without time zone
);

-- Indexes
CREATE UNIQUE INDEX "task_record_uuid_idx" ON "wenz_task_record" USING btree ("uuid");
CREATE INDEX "task_record_userId_idx" ON "wenz_task_record" USING btree ("userId");
CREATE INDEX "task_record_taskId_idx" ON "wenz_task_record" USING btree ("taskId");


--
-- MIGRATION VERSION FOR wenzflow
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('wenzflow', '20251203193644044', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20251203193644044', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod', '20240516151843329', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240516151843329', "timestamp" = now();

--
-- MIGRATION VERSION FOR serverpod_auth
--
INSERT INTO "serverpod_migrations" ("module", "version", "timestamp")
    VALUES ('serverpod_auth', '20240520102713718', now())
    ON CONFLICT ("module")
    DO UPDATE SET "version" = '20240520102713718', "timestamp" = now();


COMMIT;
